Attribute VB_Name = "modFunctions"
'-----------------------------------------------------
' MirageBot Functions Module
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Private Declare Function PlaySoundA Lib "winmm.dll" (ByVal lpszName As String, ByVal hModule As Long, ByVal dwFlags As Long) As Long
Private Declare Function FlashWindowEx Lib "user32" (FWInfo As FLASHWINFO) As Boolean
Private Type FLASHWINFO
  cbSize As Long     ' size of structure
  hwnd As Long       ' hWnd of window to use
  dwFlags As Long    ' Flags, see below
  uCount As Long     ' Number of times to flash window
  dwTimeout As Long  ' Flash rate of window in milliseconds. 0 is default.
End Type

'FlashWindow Constants
Private Const FLASHW_STOP        As Long = 0
Private Const FLASHW_CAPTION     As Long = 1
Private Const FLASHW_TRAY        As Long = 2
Private Const FLASHW_ALL         As Long = FLASHW_CAPTION Or FLASHW_TRAY
Private Const FLASHW_TIMER       As Long = 4
Private Const FLASHW_TIMERNOFG   As Long = 12

'PlaySoundA Constants
Public Const SND_APPLICATION    As Long = &H80       '  look for application specific association
Public Const SND_ALIAS          As Long = &H10000    '  name is a WIN.INI [sounds] entry
Public Const SND_ALIAS_ID       As Long = &H110000   '  name is a WIN.INI [sounds] entry identifier
Public Const SND_ASYNC          As Long = &H1        '  play asynchronously
Public Const SND_FILENAME       As Long = &H20000    '  name is a file name
Public Const SND_LOOP           As Long = &H8        '  loop the sound until next sndPlaySound
Public Const SND_MEMORY         As Long = &H4        '  lpszSoundName points to a memory file
Public Const SND_NODEFAULT      As Long = &H2        '  silence not default, if sound not found
Public Const SND_NOSTOP         As Long = &H10       '  don't stop any currently playing sound
Public Const SND_NOWAIT         As Long = &H2000     '  don't wait if the driver is busy
Public Const SND_PURGE          As Long = &H40       '  purge non-static events for task
Public Const SND_RESOURCE       As Long = &H40004    '  name is a resource name or atom
Public Const SND_SYNC           As Long = &H0        '  play synchronously (default)

Private Const GWL_EXSTYLE = (-20)
Private Const WS_EX_LAYERED = &H80000
Private Const LWA_ALPHA = &H2

Public Sub ChangeOpacity(Value As Long)
    SetWindowLong frmBot.hwnd, GWL_EXSTYLE, WS_EX_LAYERED
    SetLayeredWindowAttributes frmBot.hwnd, 0, 255 * (Value / 100), LWA_ALPHA
End Sub

Public Function IsFocusActive(Username As String, ByRef frm As Form) As Boolean
On Error GoTo hErr:
    Dim F As Form
    For Each F In Forms
        If F.Name = "frmChatFocus" Then
            If LCase$(Suffix(F.FocusedUser)) = LCase$(Suffix(Username)) Then
                Set frm = F
                IsFocusActive = True
                Exit Function
            End If
        End If
    Next F
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "Main", "IsFocusActive"
End Function

Public Function TestIDE() As Boolean
     On Error GoTo IDEInUse
     Debug.Print 1 \ 0 'division by zero error
     TestIDE = False
     Exit Function
IDEInUse:
     TestIDE = True
End Function

Public Sub ErrorHandler(ByRef Descr As String, ByRef Erl As Long, ByRef Class As String, ByRef Procedure As String)
On Error Resume Next
    frmBot.mnuError.Visible = True
    Dim FF As Integer
    FF = FreeFile
    Open AppData & "ErrorLog.txt" For Append As #FF
        Print #FF, App.Major & "." & App.Minor & "." & App.Revision & _
            " | " & Class & "." & Procedure & " (line: " & Erl & ") -> " & Descr
    Close #FF
End Sub

Public Function ArrayInit(ByVal NotValue As Long) As Boolean
    ArrayInit = Not (NotValue = -1&)
    If App.LOGMODE <> 0 Then Exit Function
    On Error Resume Next
    Debug.Assert 0.1
    On Error GoTo 0
End Function

Public Function PlaySound(sFilePath As String, Optional lFlags As Long = SND_FILENAME Or SND_ASYNC) As Long
    PlaySound = PlaySoundA(sFilePath, 0&, lFlags)
End Function

Public Sub FlashWindow()
    Dim FWInfo As FLASHWINFO
    With FWInfo
       .cbSize = 20
       .hwnd = frmBot.hwnd
       .dwFlags = FLASHW_ALL
       .uCount = 3
       .dwTimeout = 500
    End With
    Call FlashWindowEx(FWInfo)
End Sub

Public Sub AddBuffer(ByRef B As String, T As String, S As String, Optional L As Long = 0)
    If Len(S) > L Then B = B & T & S & vbNewLine
End Sub

Public Function Matches(ByVal strText As String, ByVal strMatch As String) As Boolean
    If Len(strText) = 0 Then Exit Function
    Call PrepareCheck(strMatch)
    Matches = (LCase$(strText) Like LCase$(strMatch))
End Function
Public Sub PrepareCheck(ByRef S As String)
    If InStrB(S, "[") <> 0 Then S = Replace$(S, "[", "")
    If InStrB(S, "]") <> 0 Then S = Replace$(S, "]", "")
    If InStrB(S, "") <> 0 Then S = Replace$(S, "", "[[]")
    If InStrB(S, "") <> 0 Then S = Replace$(S, "", "[]]")
    If InStrB(S, "#") <> 0 Then S = Replace$(S, "#", "[#]")
    If InStrB(S, "-") <> 0 Then S = Replace$(S, "-", "[-]")
End Sub

Public Function YesNo(bool As Boolean) As String
    If bool Then YesNo = "Y" Else YesNo = "N"
End Function
Public Function IsYes(str As String) As Boolean
    IsYes = (UCase$(str) = "Y")
End Function
Public Function YesNoToChecked(S As String) As CheckBoxConstants
    If UCase$(S) = "Y" Then YesNoToChecked = vbChecked Else YesNoToChecked = vbUnchecked
End Function
Public Function IsEnabled(bool As Boolean) As String
    If bool Then IsEnabled = "enabled" Else IsEnabled = "disabled"
End Function
Public Function OnOff(bool As Boolean) As String
    If bool Then OnOff = "on" Else OnOff = "off"
End Function
Public Function Encrypt(ByVal Text As String) As String
    Dim Char As String * 1, NewText As String, I As Integer
    For I = 1 To Len(Text)
        Char = Mid$(Text, I, 1)
        Select Case Asc(Char)
            Case 65 To 90: Char = Chr$(Asc(Char) + 125)
            Case 97 To 122: Char = Chr$(Asc(Char) + 119)
            Case 48 To 57: Char = Chr$(Asc(Char) + 194)
        End Select
        NewText = NewText & Char
    Next I
    Encrypt = NewText
End Function
Public Function Decrypt(ByVal Text As String) As String
    Dim Char As String * 1, NewText As String, I As Integer
    For I = 1 To Len(Text)
        Char = Mid$(Text, I, 1)
        Select Case Asc(Char)
            Case 190 To 215: Char = Chr$(Asc(Char) - 125)
            Case 216 To 241: Char = Chr$(Asc(Char) - 119)
            Case 242 To 251: Char = Chr$(Asc(Char) - 194)
        End Select
        NewText = NewText & Char
    Next I
    Decrypt = NewText
End Function
Public Function Hex2Color(strHexValue As String) As Long
    strHexValue = Right$("010101" & strHexValue, 6)
    strHexValue = Replace$(strHexValue, "00", "01")
    Hex2Color = Val("&H0" & Right$(strHexValue, 2) & StrReverse$(Mid$(strHexValue, 2, 2)) & Left$(strHexValue, 2))
End Function
Public Function Color2Hex(lngValue As String) As String
    Dim strHexValue As String
    strHexValue = Right$("000000" & Hex$(lngValue), 6)
    Color2Hex = Right$(strHexValue, 2) & StrReverse$(Mid$(strHexValue, 2, 2)) & Left$(strHexValue, 2)
End Function

